import {FunctionComponent} from 'react';

import * as i18nBlock from 'i18n/components';

import Box from 'components/Box/Box';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';
import SocMediaVK from 'icons/illustrations/SocMedia/SocMediaVK';
import SocMediaZen from 'icons/illustrations/SocMedia/SocMediaZen';
import SocMediaTwitter from 'icons/illustrations/SocMedia/SocMediaTwitter';
import SocMediaTelegram from 'icons/illustrations/SocMedia/SocMediaTelegram';

const AmpSocialLinks: FunctionComponent = () => {
    const width = 32;
    const height = 32;

    return (
        <Box between="1">
            <div>{i18nBlock.footerDotSocials()}</div>

            <Box inline between="2">
                <AmpLink url="https://vk.com/travel.yandex" target="_blank">
                    <SocMediaVK width={width} height={height} />
                </AmpLink>

                <AmpLink url="https://t.me/yandex_travel" target="_blank">
                    <SocMediaTelegram width={width} height={height} />
                </AmpLink>

                <AmpLink
                    url="https://zen.yandex.ru/yandextravel"
                    target="_blank"
                >
                    <SocMediaZen width={width} height={height} />
                </AmpLink>

                <AmpLink url="https://twitter.com/yandextravel" target="_blank">
                    <SocMediaTwitter width={width} height={height} />
                </AmpLink>
            </Box>
        </Box>
    );
};

export default AmpSocialLinks;
