import {FunctionComponent} from 'react';

import {PRODUCTION_PROJECT_URL, YANDEX_ROOT_PATH} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import TouchLogoYaSign from 'icons/illustrations/Touch/TouchLogoYaSign';
import TouchLogoTravel from 'icons/illustrations/Touch/TouchLogoTravel';
import TouchLogoTravelSign from 'icons/illustrations/Touch/TouchLogoTravelSign';

import cx from './AmpLogo.scss';

interface IAmpLogoProps extends IWithClassName {}

const AmpLogo: FunctionComponent<IAmpLogoProps> = ({className}) => {
    return (
        <div className={cx(className)}>
            <a
                href={YANDEX_ROOT_PATH}
                target="_blank"
                rel="noopener noreferrer"
            >
                <TouchLogoYaSign className={cx('yandexLogoSign')} />
            </a>
            <a href={PRODUCTION_PROJECT_URL}>
                <TouchLogoTravelSign className={cx('travelLogoSign')} />
                <TouchLogoTravel className={cx('travelLogoLabel')} />
            </a>
        </div>
    );
};

export default AmpLogo;
