import {FunctionComponent} from 'react';

import {TImage} from 'types/common/TImage';
import {IWithClassName} from 'types/withClassName';

import getSrcSetString from 'utilities/images/getSrcSetString';

interface IAmpImageProps extends IWithClassName {
    src: string;
    alt?: string;
    width: number;
    height: number;
    responsiveSet?: TImage[];
    withSchemaOrg?: boolean;
}

const AmpImage: FunctionComponent<IAmpImageProps> = ({
    className,
    src,
    alt,
    width,
    height,
    responsiveSet,
    children,
    withSchemaOrg,
}) => {
    const srcSetString = getSrcSetString(responsiveSet);
    const schemaOrgAttrs = withSchemaOrg
        ? {itemScope: '', itemType: 'https://schema.org/ImageObject'}
        : {};

    return (
        <amp-img
            class={className}
            src={src}
            alt={alt}
            layout="fixed"
            width={width}
            height={height}
            srcSet={srcSetString}
            itemprop="contentUrl"
            {...schemaOrgAttrs}
        >
            {children}
        </amp-img>
    );
};

export default AmpImage;
