import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {TLinkTarget} from 'types/common/TLinkTarget';

import cx from './AmpLink.scss';

interface IAmpLinkProps extends IWithClassName {
    url: string;
    target?: TLinkTarget;
    theme?: 'normal' | 'black';
}

const AmpLink: FunctionComponent<IAmpLinkProps> = ({
    className,
    theme = 'normal',
    target,
    url,
    children,
}) => {
    return (
        <a
            className={cx('root', `root_theme_${theme}`, className)}
            href={url}
            target={target}
            rel={target === '_blank' ? 'noopener noreferrer' : undefined}
        >
            {children}
        </a>
    );
};

export default AmpLink;
