import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './AmpLinkButton.scss';

interface IAmpLinkButtonProps extends IWithClassName {
    theme: 'normal' | 'black';
    onClick?: string;
}

const AmpLinkButton: FunctionComponent<IAmpLinkButtonProps> = ({
    className,
    children,
    theme,
    onClick,
}) => {
    return (
        <button
            className={cx('root', `root_theme_${theme}`, className)}
            // @ts-ignore
            on={onClick}
        >
            {children}
        </button>
    );
};

export default AmpLinkButton;
