import {ReactNode, FunctionComponent} from 'react';
import Helmet from 'react-helmet';

import {IWithClassName} from 'types/withClassName';

import CloseIcon from 'icons/24/Close';

import cx from './AmpModal.scss';

interface IAmpModalProps extends IWithClassName {
    id: string;
    children: ReactNode;
    theme?: 'primary' | 'overlay';
    animation?: 'fade-in' | 'fly-in-bottom' | 'fly-in-top';
}

const AmpModal: FunctionComponent<IAmpModalProps> = ({
    id,
    className,
    children,
    theme = 'primary',
    animation,
}) => {
    return (
        <>
            <Helmet>
                <script
                    async
                    custom-element="amp-lightbox"
                    src="https://cdn.ampproject.org/v0/amp-lightbox-0.1.js"
                />
            </Helmet>
            <amp-lightbox
                id={id}
                layout="nodisplay"
                animate-in={animation}
                scrollable=""
            >
                <div
                    className={cx(
                        'content',
                        `content_theme_${theme}`,
                        className,
                    )}
                >
                    <button
                        className={cx('closeButton')}
                        // @ts-ignore
                        on={`tap:${id}.close`}
                    >
                        <CloseIcon />
                    </button>
                    {children}
                </div>
            </amp-lightbox>
        </>
    );
};

export default AmpModal;
