import {FunctionComponent} from 'react';
import {last} from 'lodash';

import {getAbsoluteUrl} from 'utilities/url';
import {hotelsURLs} from 'projects/hotels/utilities/urls/index';
import {isGeoRegionBreadcrumb} from 'projects/hotels/utilities/isGeoRegionBreadcrumb/isGeoRegionBreadcrumb';

import * as i18nBlockPage from 'i18n/hotels-HotelPage';

import Box from 'components/Box/Box';
import BackLink from './components/BackLink/BackLink';
import AmpRooms from './components/AmpRooms/AmpRooms';
import HotelCard from './components/HotelCard/HotelCard';
import SchemaMarkup, {
    getHotelSchemaMarkup,
} from 'components/SchemaMarkup/SchemaMarkup';
import AmpHotelHelmet from './components/AmpHotelHelmet/AmpHotelHelmet';
import AmpHotelReviews from './components/AmpHotelReviews/AmpHotelReviews';
import AmpHotelSearchForm from './components/AmpHotelSearchForm/AmpHotelSearchForm';
import AmpHotelBreadcrumbs from './components/AmpHotelBreadcrumbs/AmpHotelBreadcrumbs';
import AmpHotelFeatureRatings from './components/AmpHotelFeatureRatings/AmpHotelFeatureRatings';

import {hotelInfo} from 'server/api/HotelSearchAPI/__mocks__/getHotelInfoResponse200';

import cx from './AmpHotelPage.scss';

const AmpHotelPage: FunctionComponent = () => {
    const {hotel, seoInfo, breadcrumbs, offersInfo, ratingsInfo, reviewsInfo} =
        hotelInfo;

    const regionsBreadcrumbs = breadcrumbs.items.filter(isGeoRegionBreadcrumb);
    const region = last(regionsBreadcrumbs);
    const hotelMarkupData = getHotelSchemaMarkup(hotelInfo);

    return (
        <>
            <AmpHotelHelmet hotel={hotel} seoInfo={seoInfo} />

            <SchemaMarkup data={hotelMarkupData} />

            <div>
                {region?.linguistics.genitiveCase && (
                    <div className={cx('header')}>
                        <BackLink
                            title={`${i18nBlockPage.geoRegionPrefix()} ${
                                region.linguistics.genitiveCase
                            }`}
                            url={getAbsoluteUrl(
                                hotelsURLs.getSearchPage({geoId: region.geoId}),
                            )}
                        />
                    </div>
                )}

                <Box between="3" above="3">
                    <HotelCard hotel={hotel} />

                    <AmpHotelSearchForm />

                    <AmpRooms
                        offersInfo={offersInfo}
                        hotelSlug={hotel.hotelSlug}
                    />

                    <AmpHotelFeatureRatings
                        featureRatings={ratingsInfo.featureRatings}
                    />

                    <AmpHotelReviews hotel={hotel} reviewsInfo={reviewsInfo} />

                    <AmpHotelBreadcrumbs breadcrumbs={breadcrumbs} />
                </Box>
            </div>
        </>
    );
};

export default AmpHotelPage;
