import {FunctionComponent} from 'react';

import {URLs} from 'constants/urls';

import {IBreadcrumbs} from 'reducers/hotels/hotelPage/hotelInfo/types';

import {getAbsoluteUrl} from 'utilities/url';
import {getBreadcrumbInfo} from 'projects/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';

import * as i18block from 'i18n/hotels-GeoRegionPage';

import Flex from 'components/Flex/Flex';
import ArrowRightIcon from 'icons/12/ArrowRight';
import Intersperse from 'components/Intersperse/Intersperse';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';
import AmpHotelBreadcrumb from './components/AmpHotelBreadcrumb/AmpHotelBreadcrumb';
import SchemaMarkup, {
    getMetaBreadcrumbList,
} from 'components/SchemaMarkup/SchemaMarkup';

import cx from './AmpHotelBreadcrumbs.scss';

interface IAmpHotelBreadcrumbsProps {
    breadcrumbs: IBreadcrumbs;
}

const ICON_SIZES = {
    width: 8,
    height: 8,
};

const AmpHotelBreadcrumbs: FunctionComponent<IAmpHotelBreadcrumbsProps> = ({
    breadcrumbs,
}) => {
    const hotelsBreadcrumb = {
        name: i18block.breadCrumbHotel(),
        url: getAbsoluteUrl(URLs.hotels),
    };
    const markupBreadcrumbs = breadcrumbs.items.map(breadcrumb => {
        const {text, link} = getBreadcrumbInfo(breadcrumb, breadcrumbs);

        return {
            name: text,
            url: getAbsoluteUrl(link),
        };
    });

    return (
        <div className={cx('root')}>
            <SchemaMarkup
                data={getMetaBreadcrumbList([
                    hotelsBreadcrumb,
                    ...markupBreadcrumbs,
                ])}
            />

            <HorizontalScroller offset="3">
                <Flex alignItems="center" inset="3" textSize="s">
                    <Intersperse
                        separator={
                            <ArrowRightIcon
                                className={cx('separator')}
                                {...ICON_SIZES}
                            />
                        }
                    >
                        <AmpLink url={hotelsBreadcrumb.url}>
                            {hotelsBreadcrumb.name}
                        </AmpLink>
                        {breadcrumbs.items.map(breadcrumb => (
                            <AmpHotelBreadcrumb
                                key={breadcrumb.slug}
                                breadcrumb={breadcrumb}
                                allBreadcrumbs={breadcrumbs}
                            />
                        ))}
                    </Intersperse>
                </Flex>
            </HorizontalScroller>
        </div>
    );
};

export default AmpHotelBreadcrumbs;
