import {FunctionComponent} from 'react';

import {
    IBreadcrumbs,
    TBreadcrumb,
} from 'reducers/hotels/hotelPage/hotelInfo/types';

import {getAbsoluteUrl} from 'utilities/url';
import {isHotelBreadcrumb} from 'projects/hotels/utilities/isHotelBreadcrumb/isHotelBreadcrumb';
import {getBreadcrumbInfo} from 'projects/hotels/pages/GeoRegionPage/utilities/getBreadcrumbInfo';

import AmpLink from 'projects/amp/components/AmpLink/AmpLink';

import cx from './AmpHotelBreadcrumb.scss';

interface IAmpHotelBreadcrumbProps {
    breadcrumb: TBreadcrumb;
    allBreadcrumbs: IBreadcrumbs;
}

const AmpHotelBreadcrumb: FunctionComponent<IAmpHotelBreadcrumbProps> = ({
    breadcrumb,
    allBreadcrumbs,
}) => {
    const {text, link} = getBreadcrumbInfo(breadcrumb, allBreadcrumbs);

    return link && !isHotelBreadcrumb(breadcrumb) ? (
        <AmpLink className={cx('root')} url={getAbsoluteUrl(link)}>
            {text}
        </AmpLink>
    ) : (
        <span className={cx('root')}>{text}</span>
    );
};

export default AmpHotelBreadcrumb;
