import {FunctionComponent} from 'react';

import {IFeatureRatingInfo} from 'types/hotels/hotel/IFeatureRating';

import {getRatingMod} from './utilities/getRatingMod';

import * as i18nBlock from 'i18n/hotels-HotelReviews';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import Heading from 'components/Heading/Heading';

import cx from './AmpHotelFeatureRatings.scss';

interface IAmpHotelFeatureRatingsProps {
    featureRatings: IFeatureRatingInfo[];
}

const AmpHotelFeatureRatings: FunctionComponent<IAmpHotelFeatureRatingsProps> =
    ({featureRatings}) => {
        const canRenderFeatures = featureRatings.length > 0;

        if (!canRenderFeatures) {
            return null;
        }

        return (
            <Card inset="4">
                <Heading level="2">{i18nBlock.guestsLiked()}</Heading>

                <Box between="3" above="3" className={cx('ratings')}>
                    {featureRatings.map(({id, name, positivePercent}) => (
                        <div key={id} className={cx('feature')}>
                            <div>
                                <span>{name}</span>
                                <span className={cx('feature__value')}>
                                    {`${positivePercent}%`}
                                </span>
                            </div>
                            <div
                                className={cx(
                                    'line',
                                    `line_${getRatingMod(positivePercent)}`,
                                )}
                                style={{width: `${positivePercent}%`}}
                            />
                        </div>
                    ))}
                </Box>
            </Card>
        );
    };

export default AmpHotelFeatureRatings;
