import {FunctionComponent} from 'react';

import {IHotel} from 'types/hotels/hotel/IHotel';
import {IHotelSeoInfo} from 'types/hotels/hotel/ISeoInfo';
import {EHotelImageAltayStandardSize} from 'types/hotels/common/EHotelImageAltayStandardSize';

import {getAbsoluteUrl} from 'utilities/url';
import {hotelsURLs} from 'projects/hotels/utilities/urls/index';
import {parseImageUrlTemplate} from 'projects/hotels/utilities/prepareAndParseImages/prepareAndParseImages';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

interface IAmpHotelHelmetProps {
    hotel: IHotel;
    seoInfo: IHotelSeoInfo;
}

const AmpHotelHelmet: FunctionComponent<IAmpHotelHelmetProps> = ({
    hotel,
    seoInfo,
}) => {
    const {
        title,
        description,
        openGraph: {title: ogTitle, description: ogDescription},
    } = seoInfo;

    const firstImage = hotel.images[0];

    const originHotelUrl = getAbsoluteUrl(
        hotelsURLs.getHotelUrlByHotelSlug(hotel.hotelSlug),
    );

    const ogImage = parseImageUrlTemplate(
        firstImage?.urlTemplate || '',
        EHotelImageAltayStandardSize.L,
        firstImage?.sizes,
    );

    const imgSizes = firstImage?.sizes ?? [];
    const ogImageSize = imgSizes.find(
        imgSize => imgSize.size === EHotelImageAltayStandardSize.L,
    );

    return (
        <>
            <DocumentMeta
                title={title}
                description={description}
                canonicalUrl={originHotelUrl}
            />

            <SocialSharingMeta
                url={originHotelUrl}
                title={ogTitle}
                description={ogDescription}
                image={ogImage}
                imageHeight={ogImageSize?.height ?? ''}
                imageWidth={ogImageSize?.width ?? ''}
                twitterCardType="summary_large_image"
            />
        </>
    );
};

export default AmpHotelHelmet;
