import {FunctionComponent} from 'react';

import {HOTEL_REVIEWS_ANCHOR} from 'constants/urls/anchors';

import {IWithClassName} from 'types/withClassName';

import {getAbsoluteUrl} from 'utilities/url';
import {hotelsURLs} from 'projects/hotels/utilities/urls';
import getUrlWithUpdatedHash from 'utilities/url/getUrlWithUpdatedHash';

import * as i18nBlock from 'i18n/hotels-Common';

import Flex from 'components/Flex/Flex';
import Rating from 'components/Rating/Rating';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';

interface IAmpHotelRatingProps extends IWithClassName {
    hotelSlug: string;
    rating: number | null;
    totalTextReviewCount: number;
}

const AmpHotelRating: FunctionComponent<IAmpHotelRatingProps> = ({
    className,
    hotelSlug,
    rating,
    totalTextReviewCount,
}) => {
    const originHotelUrl = getAbsoluteUrl(
        getUrlWithUpdatedHash(
            hotelsURLs.getHotelUrlByHotelSlug(hotelSlug),
            HOTEL_REVIEWS_ANCHOR,
        ),
    );

    return (
        <Flex
            className={className}
            alignItems="center"
            between="2"
            inline
            textSize="m"
        >
            <Rating rating={rating} size="m" />
            {totalTextReviewCount > 0 && (
                <AmpLink url={originHotelUrl}>
                    {i18nBlock.totalReviewCount({
                        totalReviewCount: totalTextReviewCount,
                    })}
                </AmpLink>
            )}
        </Flex>
    );
};

export default AmpHotelRating;
