import {FunctionComponent} from 'react';

import {HOTEL_REVIEWS_ANCHOR} from 'constants/urls/anchors';

import {IHotel} from 'types/hotels/hotel/IHotel';
import {IHotelReviewsInfo} from 'server/api/HotelSearchAPI/types/IHotelReviews';

import {getAbsoluteUrl} from 'utilities/url';
import {hotelsURLs} from 'projects/hotels/utilities/urls';
import getUrlWithUpdatedHash from 'utilities/url/getUrlWithUpdatedHash';

import * as i18nBlock from 'i18n/hotels-Common';
import * as i18nReviewsBlock from 'i18n/hotels-HotelReviews';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import Rating from 'components/Rating/Rating';
import Heading from 'components/Heading/Heading';
import Separator from 'components/Separator/Separator';
import Intersperse from 'components/Intersperse/Intersperse';
import AmpHotelReview from './components/AmpHotelReview/AmpHotelReview';
import AmpButtonLink from 'projects/amp/components/AmpButtonLink/AmpButtonLink';

import cx from './AmpHotelReviews.scss';

interface IAmpHotelReviewsProps {
    hotel: IHotel;
    reviewsInfo: IHotelReviewsInfo;
}

const AmpHotelReviews: FunctionComponent<IAmpHotelReviewsProps> = ({
    hotel,
    reviewsInfo,
}) => {
    const {rating, hotelSlug} = hotel;
    const {totalTextReviewCount, textReviews} = reviewsInfo;

    return (
        <Card inset="4">
            <Box between="2" below="4" inline>
                <Rating rating={rating} size="l" />

                <Heading level="2">
                    {i18nBlock.totalReviewCount({
                        totalReviewCount: totalTextReviewCount,
                    })}
                </Heading>
            </Box>

            <Intersperse separator={<Separator margin="4" />}>
                {textReviews
                    .filter(review => Boolean(review.author))
                    .map(review => (
                        <AmpHotelReview key={review.id} review={review} />
                    ))}
            </Intersperse>

            <AmpButtonLink
                className={cx('moreReviewButton')}
                theme="secondary"
                url={getAbsoluteUrl(
                    getUrlWithUpdatedHash(
                        hotelsURLs.getHotelUrlByHotelSlug(hotelSlug),
                        HOTEL_REVIEWS_ANCHOR,
                    ),
                )}
            >
                {i18nReviewsBlock.moreReviews()}
            </AmpButtonLink>
        </Card>
    );
};

export default AmpHotelReviews;
