import {FunctionComponent} from 'react';

import {ITextReview} from 'types/hotels/hotel/IHotelTextReview';

import {humanFormatDate} from 'utilities/dateUtils';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Stars from 'components/Stars/Stars';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';
import AmpImage from 'projects/amp/components/AmpImage/AmpImage';

import cx from './AmpHotelReview.scss';

const MAX_REVIEW_STARS = 5;

interface IAmpHotelReviewProps {
    review: ITextReview;
}

const AmpHotelReview: FunctionComponent<IAmpHotelReviewProps> = ({review}) => {
    const {author, rating, updatedAt} = review;

    if (!author) {
        return null;
    }

    return (
        <Box between="2" textSize="m">
            <Flex between="2" flexDirection="row" alignItems="center" inline>
                {author.avatarUrl && (
                    <AmpImage
                        className={cx('avatar')}
                        src={author.avatarUrl}
                        width={40}
                        height={40}
                    />
                )}
                <div>
                    <div>
                        {author.profileUrl ? (
                            <AmpLink
                                className={cx('authorName')}
                                url={author.profileUrl}
                            >
                                {author.name}
                            </AmpLink>
                        ) : (
                            <span className={cx('authorName')}>
                                {author.name}
                            </span>
                        )}

                        <span className={cx('date')}>
                            {humanFormatDate(updatedAt)}
                        </span>
                    </div>

                    <Stars
                        totalStarCount={MAX_REVIEW_STARS}
                        starCount={rating}
                    />
                </div>
            </Flex>
            <div>{review.text}</div>
        </Box>
    );
};

export default AmpHotelReview;
