import {FunctionComponent} from 'react';

import {IHotelOffersInfo} from 'server/api/HotelSearchAPI/types/IOffersInfo';

import Box from 'components/Box/Box';
import AmpRoom from './components/AmpRoom/AmpRoom';

interface IAmpRoomsProps {
    offersInfo: IHotelOffersInfo;
    hotelSlug: string;
}

const AmpRooms: FunctionComponent<IAmpRoomsProps> = ({
    offersInfo,
    hotelSlug,
}) => {
    const {rooms} = offersInfo;

    if (!rooms?.length) {
        return null;
    }

    return (
        <Box between="3">
            {rooms.map(room => (
                <AmpRoom key={room.id} room={room} hotelSlug={hotelSlug} />
            ))}
        </Box>
    );
};

export default AmpRooms;
