import {FunctionComponent} from 'react';

import {HOTEL_ROOM_ANCHOR} from 'constants/urls/anchors';

import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

import {getAbsoluteUrl} from 'utilities/url';
import getUrlWithUpdatedHash from 'utilities/url/getUrlWithUpdatedHash';
import {getAbsoluteHotelUrl} from 'projects/hotels/utilities/urls/getAbsoluteHotelUrl';
import {convertHotelOrRoomImages} from 'projects/hotels/utilities/prepareAndParseImages/prepareAndParseImages';

import * as i18nBlock from 'i18n/hotels-HotelPageOffersInfo';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';
import AmpRoomInfo from './components/AmpRoomInfo/AmpRoomInfo';
import AmpImage from 'projects/amp/components/AmpImage/AmpImage';
import AmpCarousel from 'projects/amp/components/AmpCarousel/AmpCarousel';
import AmpButtonLink from 'projects/amp/components/AmpButtonLink/AmpButtonLink';
import RoomBedGroupsAndSize from 'projects/hotels/components/RoomBedGroupsAndSize/RoomBedGroupsAndSize';

import cx from './AmpRoom.scss';

const HOTEL_IMAGE_SIZE_NAME = 'L';
const CAROUSEL_HEIGHT = 164;

interface IAmpRoomProps {
    room: IHotelRoom;
    hotelSlug: string;
}

const AmpRoom: FunctionComponent<IAmpRoomProps> = ({room, hotelSlug}) => {
    const convertedImages = room.images
        ? convertHotelOrRoomImages(room.images, HOTEL_IMAGE_SIZE_NAME)
        : null;

    const originalPageUrl = getAbsoluteHotelUrl({slug: hotelSlug});

    return (
        <Card className={cx('root')}>
            {convertedImages && (
                <AmpCarousel height={CAROUSEL_HEIGHT}>
                    {convertedImages.map(
                        image =>
                            image.size && (
                                <AmpImage
                                    key={image.src}
                                    src={image.src}
                                    alt={image.alt}
                                    responsiveSet={image.additionalSizes}
                                    height={CAROUSEL_HEIGHT}
                                    width={
                                        (CAROUSEL_HEIGHT / image.size?.height) *
                                        image.size?.width
                                    }
                                />
                            ),
                    )}
                </AmpCarousel>
            )}

            <Box x="3" y="4">
                <Heading level="3" weight="medium">
                    {room.name}
                </Heading>

                <div className={cx('bedGroupsAndSize')}>
                    <RoomBedGroupsAndSize
                        area={room.area}
                        bedGroups={room.bedGroups}
                    />
                </div>

                <AmpRoomInfo className={cx('amenities')} room={room} />

                <Flex above="4" justifyContent="flex-end">
                    <AmpButtonLink
                        theme="primary"
                        url={
                            originalPageUrl
                                ? getUrlWithUpdatedHash(
                                      originalPageUrl,
                                      `${HOTEL_ROOM_ANCHOR}_${room.id}`,
                                  )
                                : getAbsoluteUrl()
                        }
                    >
                        {i18nBlock.checkPrices()}
                    </AmpButtonLink>
                </Flex>
            </Box>
        </Card>
    );
};

export default AmpRoom;
