import {FunctionComponent} from 'react';

import {EAmpPageIds} from 'projects/amp/constants/EAmpPageIds';

import {IWithClassName} from 'types/withClassName';
import {IHotelRoom} from 'types/hotels/offer/IHotelRoom';

import getRoomAmenityGroupComponentIconById from 'projects/hotels/utilities/amenities/getRoomAmenityGroupComponentIconById';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import AmpModal from 'projects/amp/components/AmpModal/AmpModal';
import AmpLinkButton from 'projects/amp/components/AmpLinkButton/AmpLinkButton';
import AmpRoomMainAmenities from './components/AmpRoomMainAmenities/AmpRoomMainAmenities';

import cx from './AmpRoomInfo.scss';

interface IAmpRoomInfoProps extends IWithClassName {
    room: IHotelRoom;
}

const AmpRoomInfo: FunctionComponent<IAmpRoomInfoProps> = ({
    className,
    room,
}) => {
    const {id, name, description, mainAmenities, amenityGroups} = room;
    const hasDetailedInfo =
        amenityGroups?.length || description || mainAmenities?.length;
    const modalId = `${EAmpPageIds.HOTEL_PAGE_ROOM_AMENITIES_MODAL}_${id}`;

    return (
        <div className={className}>
            {mainAmenities && Boolean(mainAmenities?.length) && (
                <AmpRoomMainAmenities amenities={mainAmenities} inline />
            )}

            {hasDetailedInfo && (
                <>
                    <AmpLinkButton
                        className={cx('moreInfoLink')}
                        theme="normal"
                        onClick={`tap:${modalId}`}
                    >
                        {i18nBlock.moreInformationAboutRoom()}
                    </AmpLinkButton>

                    <AmpModal id={modalId} animation="fade-in">
                        <Box between="5">
                            <Heading level="3">{name}</Heading>

                            {mainAmenities && (
                                <AmpRoomMainAmenities
                                    amenities={mainAmenities}
                                />
                            )}

                            {amenityGroups && (
                                <Box between="5" textSize="m">
                                    {amenityGroups.map(group => (
                                        <div key={group.id}>
                                            <TextWithIcon
                                                weight="bold"
                                                text={group.name}
                                                iconLeft={getRoomAmenityGroupComponentIconById(
                                                    group.icon,
                                                )}
                                            />
                                            <ul className={cx('list')}>
                                                <Box between="1" above="2">
                                                    {group.amenities.map(
                                                        amenity => (
                                                            <li
                                                                key={amenity.id}
                                                            >
                                                                {amenity.name}
                                                            </li>
                                                        ),
                                                    )}
                                                </Box>
                                            </ul>
                                        </div>
                                    ))}
                                </Box>
                            )}

                            {description && <Text size="m">{description}</Text>}
                        </Box>
                    </AmpModal>
                </>
            )}
        </div>
    );
};

export default AmpRoomInfo;
