import {FunctionComponent} from 'react';

import {IRoomAmenity} from 'types/hotels/offer/IHotelRoom';

import getRoomAmenityComponentIconById from 'projects/hotels/utilities/amenities/getRoomAmenityComponentIconById';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './AmpRoomMainAmenities.scss';

interface IAmpRoomMainAmenitiesProps {
    amenities: IRoomAmenity[];
    inline?: boolean;
}

const AmpRoomMainAmenities: FunctionComponent<IAmpRoomMainAmenitiesProps> = ({
    amenities,
    inline,
}) => {
    return (
        <div>
            {amenities.map(({id, name, icon}) => (
                <TextWithIcon
                    key={id}
                    className={cx('amenity', {amenity_type_inline: inline})}
                    size="m"
                    text={name}
                    iconLeft={getRoomAmenityComponentIconById(icon)}
                />
            ))}
        </div>
    );
};

export default AmpRoomMainAmenities;
