import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import ArrowLeftIcon from 'icons/16/ArrowLeft';
import AmpLink from 'projects/amp/components/AmpLink/AmpLink';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface IBackLinkProps extends IWithClassName {
    url: string;
    title: string;
}

const BackLink: FunctionComponent<IBackLinkProps> = ({url, title}) => {
    return (
        <AmpLink url={url}>
            <TextWithIcon
                text={title}
                iconLeft={ArrowLeftIcon}
                iconSize={16}
                size="m"
            />
        </AmpLink>
    );
};

export default BackLink;
