import {FunctionComponent} from 'react';

import {EAmpPageIds} from 'projects/amp/constants/EAmpPageIds';

import {IHotel} from 'types/hotels/hotel/IHotel';

import {CHAR_SPACE} from 'utilities/strings/charCodes';

import * as i18nBlock from 'i18n/hotels-HotelPage';

import LocationIcon from 'icons/16/Location';
import AmpModal from 'projects/amp/components/AmpModal/AmpModal';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import YandexStaticMaps from 'components/YandexStaticMaps/YandexStaticMaps';
import AmpLinkButton from 'projects/amp/components/AmpLinkButton/AmpLinkButton';

import cx from './AmpHotelAddress.scss';

const STATIC_MAP_SIZE = [450, 450];
const STATIC_MAP_IMG_SIZE = {
    width: 320,
    height: 320,
};
const STATIC_MAP_ZOOM = 13;
const STATIC_MAP_SCALE = '2.0';

interface IAmpHotelAddressProps {
    hotel: IHotel;
}

const AmpHotelAddress: FunctionComponent<IAmpHotelAddressProps> = ({hotel}) => {
    const textNode = (
        <>
            <span className={cx('address')}>{hotel.address}</span>
            {CHAR_SPACE}
            <AmpLinkButton
                theme="normal"
                onClick={`tap:${EAmpPageIds.HOTEL_PAGE_ADDRESS_MAP_MODAL}`}
            >
                {i18nBlock.viewLocation()}
            </AmpLinkButton>
        </>
    );

    return (
        <>
            <TextWithIcon text={textNode} iconLeft={LocationIcon} />

            <AmpModal
                className={cx('modalContent')}
                id={EAmpPageIds.HOTEL_PAGE_ADDRESS_MAP_MODAL}
                theme="overlay"
            >
                <div className={cx('map')}>
                    <YandexStaticMaps
                        layer="map"
                        coordinates={hotel.coordinates}
                        width={STATIC_MAP_IMG_SIZE.width}
                        height={STATIC_MAP_IMG_SIZE.height}
                        size={STATIC_MAP_SIZE}
                        zoom={STATIC_MAP_ZOOM}
                        scale={STATIC_MAP_SCALE}
                        shouldUseKey
                    />
                    <div className={cx('marker')} />
                </div>
            </AmpModal>
        </>
    );
};

export default AmpHotelAddress;
