import {FunctionComponent} from 'react';

import {EAmpPageIds} from 'projects/amp/constants/EAmpPageIds';

import {IWithClassName} from 'types/withClassName';
import {
    IMainHotelOrRoomAmenity,
    IHotelAmenitiesGroup,
} from 'types/hotels/hotel/IHotel';

import * as i18nBlock from 'i18n/hotels-HotelPage';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';
import AmpModal from 'projects/amp/components/AmpModal/AmpModal';
import MainAmenities from './components/MainAmenities/MainAmenities';
import AmpLinkButton from 'projects/amp/components/AmpLinkButton/AmpLinkButton';

import cx from './HotelAmenities.scss';

interface IHotelAmenitiesProps extends IWithClassName {
    mainAmenities?: IMainHotelOrRoomAmenity[];
    amenityGroups?: IHotelAmenitiesGroup[];
}

const HotelAmenities: FunctionComponent<IHotelAmenitiesProps> = ({
    className,
    mainAmenities,
    amenityGroups,
}) => {
    return (
        <div className={className}>
            {mainAmenities && <MainAmenities mainAmenities={mainAmenities} />}

            {amenityGroups && (
                <Box above="4">
                    <AmpLinkButton
                        theme="normal"
                        onClick={`tap:${EAmpPageIds.HOTEL_PAGE_AMENITIES_MODAL}`}
                    >
                        {i18nBlock.toggleAmenitiesButton()}
                    </AmpLinkButton>

                    <AmpModal
                        id={EAmpPageIds.HOTEL_PAGE_AMENITIES_MODAL}
                        animation="fade-in"
                    >
                        <Heading level="2">
                            {i18nBlock.amenitiesTitle()}
                        </Heading>
                        {mainAmenities && (
                            <MainAmenities
                                mainAmenities={mainAmenities}
                                above="5"
                            />
                        )}

                        <Box above="5" between="8" textSize="m">
                            {amenityGroups.map(group => (
                                <div key={group.id}>
                                    <div>
                                        <Text weight="bold">{group.name}</Text>
                                    </div>
                                    <ul className={cx('list')}>
                                        <Box between="1" above="2">
                                            {group.amenities.map(amenity => (
                                                <li key={amenity.id}>
                                                    {amenity.name}
                                                </li>
                                            ))}
                                        </Box>
                                    </ul>
                                </div>
                            ))}
                        </Box>
                    </AmpModal>
                </Box>
            )}
        </div>
    );
};

export default HotelAmenities;
