import {FunctionComponent} from 'react';

import {IMainHotelOrRoomAmenity} from 'types/hotels/hotel/IHotel';

import {getIconByAmenityId} from 'projects/hotels/utilities/amenities/getIconByAmenityId';

import Box, {TBoxSizes} from 'components/Box/Box';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

interface IMainAmenitiesProps {
    above?: TBoxSizes;
    mainAmenities: IMainHotelOrRoomAmenity[];
}

const MainAmenities: FunctionComponent<IMainAmenitiesProps> = ({
    above,
    mainAmenities,
}) => {
    return (
        <Box between="2" above={above}>
            {mainAmenities?.map(({id, name}) => (
                <TextWithIcon
                    key={id}
                    text={name}
                    iconLeft={getIconByAmenityId(id)}
                />
            ))}
        </Box>
    );
};

export default MainAmenities;
