import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import DefaultAviaIcon from 'icons/24/DefaultAvia';

import cx from './AirlineLogo.scss';

interface IAirlineLogoProps extends IWithQaAttributes, IWithClassName {
    logoSrc?: string;
    airlineTitle?: string;
    size?: 's' | 'm' | 'l';
    count?: number;
    zIndex?: number;
}

const ICON_SIZES = {
    s: 20,
    m: 24,
    l: 30,
};

const AirlineLogo: FunctionComponent<IAirlineLogoProps> = ({
    className,
    airlineTitle,
    logoSrc,
    size = 'm',
    count,
    zIndex,
    ...rest
}) => {
    if ((!count || count === 1) && !logoSrc) {
        return (
            <DefaultAviaIcon
                {...prepareQaAttributes(rest)}
                width={ICON_SIZES[size]}
                height={ICON_SIZES[size]}
                className={cx('root', className)}
                style={{zIndex: zIndex || 'auto'}}
            />
        );
    }

    return (
        <span
            {...prepareQaAttributes(rest)}
            className={cx(
                'root',
                `size_${size}`,
                count && 'multiple',
                className,
            )}
            style={{
                backgroundImage: logoSrc ? `url(${logoSrc})` : 'none',
                zIndex: zIndex || 'auto',
            }}
            title={airlineTitle}
            role="icon"
        >
            {count}
        </span>
    );
};

export default AirlineLogo;
