import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import AirlineLogo from 'projects/avia/components/AirlineLogo/AirlineLogo';

import cx from './AirlineLogos.scss';

interface IAirlineLogosProps extends IWithClassName, IWithQaAttributes {
    items: {
        svg: string;
        title: string;
    }[];
    size: 's' | 'm' | 'l';
}

const MAX_VIEW_AIRLINE_LOGO = 3;

const AirlineLogos: React.FC<IAirlineLogosProps> = props => {
    const {items, size, className} = props;

    return (
        <Flex
            className={cx('root', `root_size_${size}`, className)}
            inline
            nowrap
        >
            {items.length > MAX_VIEW_AIRLINE_LOGO ? (
                <AirlineLogo
                    count={items.length}
                    size={size}
                    {...prepareQaAttributes(props)}
                />
            ) : (
                items.map((item, index) => (
                    <AirlineLogo
                        key={index}
                        zIndex={index === 0 ? 3 : 3 - index}
                        className={cx('airlineLogo', {
                            airlineLogo_hasRightShadow:
                                index < items.length - 1 && items.length > 1,
                            airlineLogo_hasHorizontalTransform: index > 0,
                        })}
                        logoSrc={item.svg}
                        airlineTitle={item.title}
                        size={size}
                        {...prepareQaAttributes(props)}
                    />
                ))
            )}
        </Flex>
    );
};

export default React.memo(AirlineLogos);
