import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nRebranding from 'i18n/index-Advantages';

import Advantages, {TAdvantage} from 'components/Advantages/Advantages';
import useTitle from 'components/Advantages/hooks/useTitle';
import Fair3DImage from 'icons/raster-illustrations/M/Fair3D';
import Tariff3DImage from 'icons/raster-illustrations/M/Tariff3D';
import Safety3DImage from 'icons/raster-illustrations/M/Safety3D';
import Support3DImage from 'icons/raster-illustrations/M/Support3D';

interface IAviaAdvantages extends IWithClassName, IWithQaAttributes {}

const AviaAdvantages: React.FC<IAviaAdvantages> = props => {
    const {className} = props;

    const advantages = useMemo((): TAdvantage[] => {
        const iconWidth = 220;
        const iconHeight = 180;

        return [
            {
                description: i18nRebranding.aviaClearPriceDescription(),
                IconComponent: Fair3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.aviaAllInOnePlaceDescription(),
                IconComponent: Tariff3DImage,
                iconWidth,
                iconHeight,
            },
            {
                description: i18nRebranding.aviaTrustedPartnersDescription(),
                IconComponent: Safety3DImage,
                iconWidth,
                iconHeight,
            },

            {
                description: i18nRebranding.commonSupportDescription(),
                IconComponent: Support3DImage,
                iconWidth,
                iconHeight,
            },
        ];
    }, []);

    const title = useTitle(i18nRebranding.aviaTitle);

    return (
        <Advantages
            title={title}
            advantages={advantages}
            className={className}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(AviaAdvantages);
