import {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import * as i18nBlock from 'i18n/avia-AviaAndroidAppHeader';

import ImageIcon from 'components/ImageIcon/ImageIcon';
import Flex from 'components/Flex/Flex';

import {useCoordinator} from 'contexts/PlatformContext';

import menuIcon from './images/ic_action_bar_menu.svg';
import historyIcon from './images/ic_history.svg';

import cx from './AviaAndroidAppHeader.scss';

export const AviaAndroidAppHeader = () => {
    const coordinator = useCoordinator();

    const menuClickHandler = useCallback(() => {
        coordinator.doAction(EAppActions.OPEN_MENU, {});
    }, [coordinator]);

    const historyClickHandler = useCallback(() => {
        coordinator.doAction(EAppActions.OPEN_HISTORY, {});
    }, [coordinator]);

    return (
        <Flex justifyContent="space-between" className={cx('header')}>
            <button
                className={cx('menu')}
                type="button"
                onClick={menuClickHandler}
            >
                <ImageIcon
                    className={cx('menu-icon')}
                    src={menuIcon}
                    height={20}
                    width={20}
                />
                <span>{i18nBlock.searchDashButtonDashText()}</span>
            </button>
            <button
                className={cx('history')}
                type="button"
                onClick={historyClickHandler}
            >
                <ImageIcon src={historyIcon} height={20} width={20} />
            </button>
        </Flex>
    );
};
