import React from 'react';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/avia-booking-disclaimer';

import Box from 'components/Box/Box';
import DisclaimerLink from './components/DisclaimerLink/DisclaimerLink';

export const AviaBookingDisclaimer: React.FC = () => {
    return (
        <Box between="1">
            <Box>
                {insertJSXIntoKey(i18nBlock.content)({
                    userAgreement: <DisclaimerLink type="userAgreement" />,
                    carriageContract: (
                        <DisclaimerLink type="carriageContract" />
                    ),
                    fareRules: <DisclaimerLink type="fareRules" />,
                    passengersAndBaggageTransportationRules: (
                        <DisclaimerLink type="passengersAndBaggageTransportationRules" />
                    ),
                    transitPassengersTransportationRules: (
                        <DisclaimerLink type="transitPassengersTransportationRules" />
                    ),
                    newLine: <br />,
                })}
            </Box>
        </Box>
    );
};
