import React, {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {TDisclaimerLinkType} from 'projects/avia/components/AviaBookingDisclaimer/components/DisclaimerLink/types/TDisclaimerLinkType';

import getTexts from './utilities/getTexts';

import Link from 'components/Link/Link';

import {useCoordinator, usePlatform} from 'contexts/PlatformContext';

interface IDisclaimerLinkProps {
    type: TDisclaimerLinkType;
}

const DisclaimerLink: React.FC<IDisclaimerLinkProps> = props => {
    const {type} = props;

    const {isTravelApp} = usePlatform();
    const coordinator = useCoordinator();

    const {link, title} = getTexts(type);

    const handleClick: React.MouseEventHandler = useCallback(
        e => {
            if (isTravelApp) {
                coordinator.doAction(
                    EAppActions.NAVIGATE_TO_EXTERNAL_URL,
                    link,
                );

                e.preventDefault();
            }
        },
        [coordinator, isTravelApp, link],
    );

    return (
        <Link theme="normal" url={link} onClick={handleClick}>
            {title}
        </Link>
    );
};

export default DisclaimerLink;
