import {TDisclaimerLinkType} from '../types/TDisclaimerLinkType';

import * as i18nBlock from 'i18n/avia-booking-disclaimer';

interface ITexts {
    link: string;
    title: string;
}

export default function getTexts(key: TDisclaimerLinkType): ITexts {
    switch (key) {
        case 'carriageContract':
            return {
                link: i18nBlock.carriageContractDashLink(),
                title: i18nBlock.carriageContractDashTitle(),
            };
        case 'fareRules':
            return {
                link: i18nBlock.fareRulesDashLink(),
                title: i18nBlock.fareRulesDashTitle(),
            };
        case 'passengersAndBaggageTransportationRules':
            return {
                link: i18nBlock.passengersAndBaggageTransportationRulesDashLink(),
                title: i18nBlock.passengersAndBaggageTransportationRulesDashTitle(),
            };
        case 'transitPassengersTransportationRules':
            return {
                link: i18nBlock.transitPassengersTransportationRulesDashLink(),
                title: i18nBlock.transitPassengersTransportationRulesDashTitle(),
            };
        case 'userAgreement':
            return {
                link: i18nBlock.userAgreementDashLink(),
                title: i18nBlock.userAgreementDashTitle(),
            };
    }
}
