import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {TStationType} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import getTransferOnText from 'projects/avia/utilities/getTransferOnText';

import SmallBusIcon from 'icons/12/Bus';
import SmallTrainIcon from 'icons/12/Train';

import cx from './AviaCustomTransportType.scss';

interface IAviaCustomTransportType extends IWithClassName {
    type: TStationType;
    withTitle?: boolean;
}

const TRANSPORT_ICONS = {
    bus: <SmallBusIcon className={cx('icon')} />,
    train: <SmallTrainIcon className={cx('icon')} />,
};

export const AviaCustomTransportType: React.FC<IAviaCustomTransportType> = ({
    type,
    className,
    withTitle = true,
}) => {
    if (type === 'plane') {
        return null;
    }

    return (
        <span className={className}>
            {TRANSPORT_ICONS[type] || null}
            {withTitle && <span>{getTransferOnText(type)}</span>}
        </span>
    );
};
