import React from 'react';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';

import * as i18nBlock from 'i18n/avia-order-disclaimers';

import Modal from 'components/Modal/Modal';
import LinkButton from 'components/LinkButton/LinkButton';
import ModalWithTrigger from 'components/ModalWithTrigger/ModalWithTrigger';

import cx from './CommonAviaDisclaimer.scss';

const CommonAviaDisaclaimer: React.FC = () => {
    return insertJSXIntoKey(i18nBlock.disclaimerDashInfoDashText)({
        link: (
            <ModalWithTrigger
                renderTriggerNode={({onClick}): React.ReactNode => (
                    <LinkButton theme="normal" onClick={onClick}>
                        {i18nBlock.disclaimerDashInfoDashLinkDashText()}
                    </LinkButton>
                )}
            >
                <Modal.Content className={cx('modal')}>
                    {i18nBlock.disclaimerDashInfoDashFullDashText()}
                </Modal.Content>
            </ModalWithTrigger>
        ),
    });
};

export default CommonAviaDisaclaimer;
