import {useEffect} from 'react';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/avia-search';

import AviaLayout from 'projects/avia/components/AviaLayout';
import LayoutError500 from 'components/Layouts/LayoutError500/LayoutError500';

export default function AviaError500() {
    useEffect(() => {
        reachGoal(EAviaGoal.INTERNAL_ERROR);
    }, []);

    return (
        <AviaLayout>
            <LayoutError500
                title={i18nBlock.errorDotTitle()}
                subtitle={i18nBlock.errorDotSubtitle()}
                action={{
                    type: 'button',
                    title: i18nBlock.errorDotActionDashTitle(),
                    handler: () => document.location.reload(),
                }}
            />
        </AviaLayout>
    );
}
