import {FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';
import Card from 'components/Card/Card';
import Flex from 'components/Flex/Flex';
import Box from 'components/Box/Box';

import cx from './AviaHotelsCrossSaleMapSidebarSkeleton.scss';

export interface IAviaHotelsCrossSaleMapSidebarSkeletonProps
    extends IWithClassName {}

const AviaHotelsCrossSaleMapSidebarSkeleton: FC<IAviaHotelsCrossSaleMapSidebarSkeletonProps> =
    ({className}) => {
        return (
            <Card shadow="default" className={className}>
                <Box x={6} y={4}>
                    <TextSkeleton
                        withAnimation
                        size="xl"
                        className={cx('heading')}
                    />
                    <Flex
                        flexDirection="row"
                        justifyContent="space-between"
                        y={3}
                    >
                        <ButtonSkeleton withAnimation className={cx('icon')} />
                        <Flex flexDirection="column" className={cx('text')}>
                            <TextSkeleton withAnimation size="m" />
                            <TextSkeleton withAnimation size="s" />
                        </Flex>
                    </Flex>
                    <Flex>
                        <ButtonSkeleton withAnimation className={cx('map')} />
                    </Flex>
                    <TextSkeleton
                        withAnimation
                        size="m"
                        className={cx('link')}
                    />
                </Box>
            </Card>
        );
    };

export default AviaHotelsCrossSaleMapSidebarSkeleton;
