import React from 'react';

import {EProjectName} from 'constants/common';

import {EFooterProject} from 'components/Footer/types';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';

import {useMobile} from 'utilities/hooks/useMobile';
import {useAviaPortal} from 'utilities/hooks/useAviaPortal';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

import {usePlatform} from 'contexts/PlatformContext';

interface IAviaLayoutProps extends IWithQaAttributes {
    headerClassName?: string;
    isFixedNavigation?: boolean;
    searchFormIsStatic?: boolean;
    validateSearchFormOnMount?: boolean;
    searchFormInitialIsExpanded?: boolean;
    /**
     * Убирает информацию о текущем поиске. Не будет возможности открыть
     * поисковую форму.
     * @default false
     */
    hideSearchInformation?: boolean;
    headerBorderBottomType?: EHeaderBorderBottomType;
    showHeader?: boolean;
    showFooter?: boolean;
}

const AviaLayout: React.FC<IAviaLayoutProps> = props => {
    const {
        children,
        headerClassName,
        isFixedNavigation = true,
        searchFormIsStatic,
        validateSearchFormOnMount,
        searchFormInitialIsExpanded = false,
        hideSearchInformation = false,
        headerBorderBottomType,
        showHeader = true,
        showFooter,
    } = props;

    const isMobile = useMobile();
    const {isWeb} = usePlatform();
    const isAviaPortal = useAviaPortal();
    const withFooter = typeof showFooter === 'boolean' ? showFooter : isWeb;

    return (
        <LayoutDefault
            headerClassName={headerClassName}
            isFixedNavigation={isFixedNavigation}
            showNavigation={!isMobile && !isAviaPortal}
            showSearchForm
            showHeader={showHeader}
            searchFormIsStatic={searchFormIsStatic}
            validateSearchFormOnMount={validateSearchFormOnMount}
            searchFormInitialIsExpanded={searchFormInitialIsExpanded}
            project={EProjectName.AVIA}
            footerType={EFooterProject.AVIA}
            hasSideSheetNavigation={!isAviaPortal}
            showFooter={withFooter}
            hideTopMobileBlock={!isWeb}
            headerBorderBottomType={headerBorderBottomType}
            hideSearchInformation={hideSearchInformation}
            {...prepareQaAttributes(props)}
        >
            {children}
        </LayoutDefault>
    );
};

export default AviaLayout;
