import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/avia-plusPromo2021';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';

const PLUS_ICON_PROPS = {width: 12, height: 12};

interface IBaggagePlusInfo extends IWithClassName {
    plusPoints: number;
}

const BaggagePlusInfo: FunctionComponent<IBaggagePlusInfo> = ({
    className,
    plusPoints,
}) => {
    return (
        <TextWithIcon
            className={className}
            size="s-inset"
            spaceBetween="1"
            iconLeft={YandexPlusSignColorGradientS}
            iconSize={12}
            iconLeftProps={PLUS_ICON_PROPS}
            text={i18nBlock.mobileVariantPromoText({
                count: plusPoints,
            })}
        />
    );
};

export default BaggagePlusInfo;
