import {MutableRefObject, useEffect, useState} from 'react';

export const useMarginMobileVariantBottom = (
    buttonRef: MutableRefObject<HTMLDivElement | null>,
    linkRef: MutableRefObject<HTMLDivElement | null>,
    isButtonSubtextVisible: boolean,
): number => {
    const [marginBottom, setMarginBottom] = useState(0);

    useEffect(() => {
        /*
         * чтобы кнопка без учета текста была по вертикали по центру, а текст
         * именно под ней, а не весь блок кнопка + текст по вертикали по центру
         * приходится делать добавлять отступ снизу контейнеру
         */
        if (linkRef.current && buttonRef.current && isButtonSubtextVisible) {
            setMarginBottom(
                Math.max(
                    20 -
                        (linkRef.current.clientHeight -
                            buttonRef.current.clientHeight) /
                            2,
                    0,
                ),
            );
        }
    }, [buttonRef, isButtonSubtextVisible, linkRef]);

    return marginBottom;
};
