import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';

import useTransfersInfo from 'projects/avia/components/AviaResultVariant/components/Flights/utilities/useTransfersInfo';

import * as i18nAviaSearchBlock from 'i18n/avia-search';

import NightConnectionIcon from 'icons/12/NightConnection';
import ConnectionIcon from 'icons/12/Connection';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './TransfersCount.scss';

interface ITransfersCountProps extends IWithClassName {
    flights: IResultAviaFlight[];
}

const TransfersCount: React.FC<ITransfersCountProps> = props => {
    const {className, flights} = props;

    const transfersInfo = useTransfersInfo(flights);

    if (transfersInfo.count === 0) {
        return (
            <Text className={className} size="s" color="secondary">
                {i18nAviaSearchBlock.transferDotDirect()}
            </Text>
        );
    }

    if (transfersInfo.count > 1) {
        return (
            <div className={cx('transfers', className)}>
                <TextWithIcon
                    size="s"
                    text={i18nAviaSearchBlock.transfersCount({
                        count: transfersInfo.count,
                    })}
                    spaceBetween={1}
                    iconLeft={
                        transfersInfo.nightsCount > 0
                            ? NightConnectionIcon
                            : undefined
                    }
                    iconSize={12}
                />
            </div>
        );
    }

    return (
        <Flex
            className={cx('transfers', className)}
            inline
            between={1}
            alignItems="baseline"
            flexWrap="nowrap"
        >
            <TextWithIcon
                size="s"
                text={flights[0].to.code}
                spaceBetween={1}
                iconLeft={
                    transfersInfo.nightsCount > 0
                        ? NightConnectionIcon
                        : undefined
                }
                iconSize={12}
            />
            {transfersInfo.changeAirportCount > 0 && (
                <>
                    <ConnectionIcon />
                    <Text size="s" color="current">
                        {flights[1].from.code}
                    </Text>
                </>
            )}
        </Flex>
    );
};

export default React.memo(TransfersCount);
