import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import useTransfersInfo from 'projects/avia/components/AviaResultVariant/components/Flights/utilities/useTransfersInfo';
import getTransferOnText from 'projects/avia/utilities/getTransferOnText';

import * as i18nAviaSearchBlock from 'i18n/avia-search';

import BusIcon from 'icons/12/Bus';
import TrainIcon from 'icons/12/Train';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import SelfConnectMessage from 'projects/avia/components/AviaResultVariant/components/SelfConnectMessage/SelfConnectMessage';

import cx from './TransfersInfo.scss';

interface ITransfersInfoProps extends IWithClassName {
    flights: IResultAviaFlight[];
    variant: IResultAviaVariant;
}

const TransfersInfo: React.FC<ITransfersInfoProps> = props => {
    const {className, flights, variant} = props;

    const transfersInfo = useTransfersInfo(flights);

    if (
        !transfersInfo.count ||
        (!transfersInfo.changeAirportCount &&
            !transfersInfo.transport &&
            !variant.price.selfConnect)
    ) {
        return null;
    }

    return (
        <div className={cx('transfers', className)}>
            {transfersInfo.changeAirportCount > 0 && (
                <TextWithIcon
                    className={cx('transferLine')}
                    size="s"
                    text={i18nAviaSearchBlock.transferDotAirportDashChange()}
                />
            )}

            {transfersInfo.transport && (
                <TextWithIcon
                    className={cx('transferLine')}
                    size="s"
                    spaceBetween={1}
                    text={getTransferOnText(transfersInfo.transport)}
                    iconLeft={
                        transfersInfo.transport === 'bus' ? BusIcon : TrainIcon
                    }
                />
            )}

            <SelfConnectMessage variant={variant} />
        </div>
    );
};

export default TransfersInfo;
