import {useMemo} from 'react';
import moment from 'moment';

import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';

interface IUseTransfersInfo {
    count: number;
    nightsCount: number;
    changeAirportCount: number;
    transport: 'bus' | 'train' | null;
}

export default function useTransfersInfo(
    flights: IResultAviaFlight[],
): IUseTransfersInfo {
    return useMemo(
        () =>
            flights.reduce<IUseTransfersInfo>(
                (accTransfersInfo, flight, index) => {
                    if (index === 0) {
                        return accTransfersInfo;
                    }

                    const prevFlight = flights[index - 1];

                    accTransfersInfo.count++;

                    if (
                        !moment(prevFlight.arrival.local).isSame(
                            flight.departure.local,
                            'day',
                        )
                    ) {
                        accTransfersInfo.nightsCount++;
                    }

                    if (prevFlight.to.id !== flight.from.id) {
                        accTransfersInfo.changeAirportCount++;
                    }

                    if (flight.to.tType !== 'plane') {
                        accTransfersInfo.transport = flight.to.tType;
                    }

                    return accTransfersInfo;
                },
                {
                    count: 0,
                    nightsCount: 0,
                    changeAirportCount: 0,
                    transport: null as 'bus' | 'train' | null,
                },
            ),
        [flights],
    );
}
