import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';

import {IResultCompany} from 'selectors/avia/utils/denormalization/company';

import {CHAR_LIST_MARKER} from 'utilities/strings/charCodes';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import AirlineLogos from 'projects/avia/components/AirlineLogos/AirlineLogos';

import cx from './LogosWithTitle.scss';

interface ILogosWithTitle extends IWithClassName, IWithQaAttributes {
    companies: IResultCompany[];
    size?: 's' | 'm' | 'l';
    alignItems?: React.CSSProperties['alignItems'];
}

const LogosWithTitle: React.FC<ILogosWithTitle> = ({
    companies,
    size,
    alignItems,
    className,
    ...rest
}) => {
    const logos = useMemo(
        () =>
            companies.map(aviaCompany => ({
                svg: aviaCompany.logoSvg,
                title: aviaCompany.title,
            })),
        [companies],
    );

    const title = useMemo(
        () =>
            companies
                .map(aviaCompany => aviaCompany.title)
                .join(` ${CHAR_LIST_MARKER} `),
        [companies],
    );

    return (
        <Flex
            className={className}
            alignItems={alignItems}
            {...prepareQaAttributes(rest)}
        >
            <Box>
                <AirlineLogos
                    className={cx('logos')}
                    items={logos}
                    size={size || (companies.length > 1 ? 'm' : 'l')}
                    {...prepareQaAttributes({parent: rest, current: 'icon'})}
                />

                <Text
                    size="m"
                    {...prepareQaAttributes({parent: rest, current: 'title'})}
                >
                    {title}
                </Text>
            </Box>
        </Flex>
    );
};

export default LogosWithTitle;
