import {FunctionComponent} from 'react';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import * as i18nAviaSearchBlock from 'i18n/avia-search';

import ConnectionIcon from 'icons/12/Connection';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import Text from 'components/Text/Text';

export interface ISelfConnectDescriptionProps {
    variant: IResultAviaVariant;
}

const SelfConnectDescription: FunctionComponent<ISelfConnectDescriptionProps> =
    ({
        variant: {
            price: {selfConnect},
        },
    }) => {
        return selfConnect ? (
            <>
                <TextWithIcon
                    size="s"
                    spaceBetween={1}
                    text={
                        <Text color="current" size="s">
                            {i18nAviaSearchBlock.selfConnectShortMessage()}
                            <br />
                            {i18nAviaSearchBlock.selfConnectLongMessage()}
                        </Text>
                    }
                    iconLeft={ConnectionIcon}
                />
            </>
        ) : null;
    };

export default SelfConnectDescription;
