import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nAviaSearchBlock from 'i18n/avia-search';

import ConnectionIcon from 'icons/12/Connection';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './SelfConnectMessage.scss';

export interface ISelfConnectMessageProps extends IWithClassName {
    variant: IResultAviaVariant;
}

const SelfConnectMessage: FunctionComponent<ISelfConnectMessageProps> = ({
    variant: {
        price: {selfConnect},
    },
    className,
}) => {
    const deviceType = useDeviceType();
    const {isMobile} = deviceType;

    return selfConnect ? (
        <TextWithIcon
            className={cx(className, 'content')}
            textClassName={cx('text', deviceMods('text', deviceType))}
            size={isMobile ? 's' : 'm'}
            spaceBetween={1}
            text={i18nAviaSearchBlock.selfConnectShortMessage()}
            iconLeft={ConnectionIcon}
        />
    ) : null;
};

export default SelfConnectMessage;
