import React, {FC} from 'react';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import BaggageIconWithWeight, {
    EBaggageWithWeightIconType,
} from 'components/BaggageIconWithWeight/BaggageIconWithWeight';
import ShortRefundInfo from 'projects/avia/components/RefundInfo/ShortRefundInfo';
import useCarryOnInfo from 'projects/avia/components/AviaResultVariant/hooks/useCarryOnInfo';
import useBaggageInfo from 'projects/avia/components/AviaResultVariant/hooks/useBaggageInfo';

import cx from './TariffInfo.scss';

interface ITariffInfoProps extends IWithQaAttributes {
    selectedVariant: IResultAviaVariant;
}

const TariffInfo: FC<ITariffInfoProps> = ({selectedVariant, ...rest}) => {
    const carryOnInfo = useCarryOnInfo(selectedVariant);
    const baggageInfo = useBaggageInfo(selectedVariant);

    const weight =
        (selectedVariant.hasBaggage && baggageInfo.wt?.count) || undefined;
    const count =
        (selectedVariant.hasBaggage && baggageInfo.pc?.count) || undefined;

    return (
        <>
            <BaggageIconWithWeight
                type={EBaggageWithWeightIconType.CARRY_ON}
                included={carryOnInfo.included}
                weight={carryOnInfo.weight}
                count={carryOnInfo.places}
                {...prepareQaAttributes({parent: rest, current: 'carryOnIcon'})}
            />

            <BaggageIconWithWeight
                className={cx('baggageIcon')}
                type={EBaggageWithWeightIconType.BAGGAGE}
                included={selectedVariant.hasBaggage}
                weight={weight}
                count={count}
                {...prepareQaAttributes({parent: rest, current: 'baggageIcon'})}
            />

            <ShortRefundInfo
                className={cx('refund')}
                showCurrency
                refund={selectedVariant.price.worstRefund}
                {...prepareQaAttributes({parent: rest, current: 'refundInfo'})}
            />
        </>
    );
};

export default React.memo(TariffInfo);
