import {FC, RefObject} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Popup from 'components/Popup/Popup';
import Tariffs from 'projects/avia/components/AviaResultVariant/components/TariffSelector/components/Tariffs/Tariffs';

import cx from './TariffSelectorPopup.scss';

interface ITariffSelectorPopupProps extends IWithQaAttributes {
    isOpen: boolean;
    variants: IResultAviaVariant[];
    selectedVariant: IResultAviaVariant;
    anchorRef: RefObject<HTMLElement>;
    scope?: HTMLElement;
    onSelect(variant: IResultAviaVariant): void;
    onClose(): void;
}

const POPUP_DIRECTIONS = [
    EPopupDirection.BOTTOM_RIGHT,
    EPopupDirection.TOP_RIGHT,
];

const TariffSelectorPopup: FC<ITariffSelectorPopupProps> = props => {
    const {
        isOpen,
        variants,
        selectedVariant,
        anchorRef,
        onSelect,
        onClose,
        scope,
    } = props;
    const qa = prepareQaAttributes(props);

    return (
        <Popup
            className={cx('popupContent')}
            anchor={anchorRef}
            scope={scope ? {current: scope} : undefined}
            visible={isOpen}
            directions={POPUP_DIRECTIONS}
            motionless
            onClose={onClose}
            {...qa}
        >
            <Tariffs
                selectedVariant={selectedVariant}
                variants={variants}
                onSelect={onSelect}
                showPriceHeader
                highlightOnHover
                {...qa}
            />
        </Popup>
    );
};

export default TariffSelectorPopup;
