import {useMemo} from 'react';

import {IAviaTariffPossibleBaggage} from 'projects/avia/components/AviaResultVariant/components/TariffSelector/types';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export default function usePossibleBaggage(
    variantWithBaggage: IResultAviaVariant | null,
): IAviaTariffPossibleBaggage {
    return useMemo(() => {
        return {
            weight: variantWithBaggage?.baggage?.wt?.count || undefined,
            count: variantWithBaggage?.baggage?.pc?.count || undefined,
        };
    }, [
        variantWithBaggage?.baggage?.pc?.count,
        variantWithBaggage?.baggage?.wt?.count,
    ]);
}
