import {useMemo} from 'react';

import {IAviaCarryOn} from 'types/avia/common/IAviaCarryOn';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {getCarryOnFromVariant} from 'projects/avia/components/AviaResultVariant/hooks/useCarryOnInfo';

export interface IPreparedVariant {
    variant: IResultAviaVariant;
    carryOn: IAviaCarryOn;
}

export const usePreparedVariants = (
    variants: IResultAviaVariant[],
): IPreparedVariant[] => {
    return useMemo(
        () =>
            variants.map(variant => ({
                variant,
                carryOn: getCarryOnFromVariant(variant),
            })),
        [variants],
    );
};
