import {useMemo} from 'react';
import uniq from 'lodash/uniq';

import {isNotNull} from 'types/utilities';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

type TResultAviaVariantOptional =
    | IResultAviaVariant[]
    | IResultAviaVariant
    | null
    | undefined;

function getCheapestVariant(
    variant: TResultAviaVariantOptional,
): IResultAviaVariant | null {
    return (Array.isArray(variant) ? variant[0] : variant) ?? null;
}

export default function useUniqVariants(
    withoutBaggageNoOrUnknownRefund: TResultAviaVariantOptional,
    withoutBaggageChargedRefund: TResultAviaVariantOptional,
    withoutBaggageFreeRefund: TResultAviaVariantOptional,
    withBaggageNoOrUnknownRefund: TResultAviaVariantOptional,
    withBaggageChargedRefund: TResultAviaVariantOptional,
    withBaggageFreeRefund: TResultAviaVariantOptional,
): IResultAviaVariant[] {
    return useMemo(() => {
        return uniq([
            getCheapestVariant(withoutBaggageNoOrUnknownRefund),
            getCheapestVariant(withoutBaggageChargedRefund),
            getCheapestVariant(withoutBaggageFreeRefund),
            getCheapestVariant(withBaggageNoOrUnknownRefund),
            getCheapestVariant(withBaggageChargedRefund),
            getCheapestVariant(withBaggageFreeRefund),
        ]).filter(isNotNull);
    }, [
        withoutBaggageNoOrUnknownRefund,
        withoutBaggageChargedRefund,
        withoutBaggageFreeRefund,
        withBaggageNoOrUnknownRefund,
        withBaggageChargedRefund,
        withBaggageFreeRefund,
    ]);
}
