import React, {useRef} from 'react';

import {IWithClassName} from 'types/withClassName';
import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import useTooltipHover from 'utilities/hooks/useTooltipHover';

import Box from 'components/Box/Box';
import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';
import TransferData from 'projects/avia/components/AviaResultVariant/components/TransferData/TransferData';
import OrderLink from 'projects/avia/components/OrderLink/OrderLink';

import cx from './TransferDataWithHint.scss';

interface ITransferDataWithHintProps extends IWithClassName {
    flights: IResultAviaFlight[];
    variant: IResultAviaVariant;
    theme?: 'light' | 'dark';
    short?: boolean;
    absoluteIcons?: boolean;
    directClassName?: string;
    withBaggage?: boolean;
}

const DIRECTION_DEFAULT = [EPopupDirection.BOTTOM, EPopupDirection.TOP];

const TransferDataWithHint: React.FC<ITransferDataWithHintProps> = props => {
    const {variant, withBaggage} = props;
    const {isHovered, handleMouseEnter, handleMouseLeave} = useTooltipHover();
    const triggerRef = useRef(null);

    const isDirectFligth = props.flights.length < 2;

    if (isDirectFligth) {
        return <TransferData {...props} />;
    }

    const cardContent = (
        <div
            className={cx('wrapper')}
            onMouseEnter={handleMouseEnter}
            onMouseLeave={handleMouseLeave}
            ref={triggerRef}
        >
            <TransferData {...props} />
        </div>
    );

    return (
        <div className={cx('root')}>
            <OrderLink variant={variant} withBaggage={withBaggage}>
                {cardContent}
            </OrderLink>

            <MessageBoxPopup
                isVisible={isHovered}
                anchorRef={triggerRef}
                direction={DIRECTION_DEFAULT}
                onClose={handleMouseLeave}
            >
                <Box className={cx('popup')} x="5" y="6">
                    <TransferData
                        flights={props.flights}
                        variant={variant}
                        theme="dark"
                        short={false}
                        size="s"
                    />
                </Box>
            </MessageBoxPopup>
        </div>
    );
};

export default TransferDataWithHint;
