import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import IPrice from 'utilities/currency/PriceInterface';

import useCarryOnInfo from 'projects/avia/components/AviaResultVariant/hooks/useCarryOnInfo';
import useBaggageInfo from 'projects/avia/components/AviaResultVariant/hooks/useBaggageInfo';

import {usePriceDiff} from 'projects/avia/hooks/usePriceDiff';

export interface ISegmentBaggageInfo {
    has: boolean;
    isToggable: boolean;
    weight: number | undefined;
    count: number | undefined;
    priceDiff: Nullable<{
        price: IPrice;
        isRoughly: boolean;
    }>;
}

export interface ISegmentCarryOnInfo {
    has: boolean;
    weight: number | undefined;
    count: number | undefined;
}

export default function useBaggageAndCarryOnInfo({
    variant,
    variantWithBaggage,
    baggageToggleIsActive,
}: {
    variant: IResultAviaVariant;
    variantWithBaggage: IResultAviaVariant | null;
    baggageToggleIsActive: boolean;
}): {
    carryOn: ISegmentCarryOnInfo;
    baggage: ISegmentBaggageInfo;
} {
    const baggageIsToggable =
        Boolean(variantWithBaggage) && !variant.hasBaggage;
    const withBaggage = baggageIsToggable
        ? baggageToggleIsActive
        : variant.hasBaggage;

    const carryOnInfo = useCarryOnInfo(
        baggageIsToggable && baggageToggleIsActive
            ? variantWithBaggage
            : variant,
    );

    const hasCarryOn = Boolean(carryOnInfo.included);
    const carryOnWeight = carryOnInfo.weight || undefined;
    const carryOnCount = carryOnInfo.places || undefined;

    const baggageInfo = useBaggageInfo(variantWithBaggage);
    const baggageWeight = baggageInfo.wt?.count || undefined;
    const baggageCount = baggageInfo.pc?.count || undefined;
    const baggagePriceDiff = usePriceDiff(
        variantWithBaggage?.price.tariff,
        variant.price.tariff,
    );

    return {
        carryOn: {
            has: hasCarryOn,
            weight: carryOnWeight,
            count: carryOnCount,
        },
        baggage: {
            has: withBaggage,
            isToggable: baggageIsToggable,
            weight: baggageWeight,
            count: baggageCount,
            priceDiff: baggagePriceDiff,
        },
    };
}
