import {useMemo} from 'react';
import flatten from 'lodash/flatten';

import {IBaggageTDTariff} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export default function useBaggageInfo(
    variant: IResultAviaVariant | null,
): IBaggageTDTariff {
    const baggageInfo = variant?.price.baggage;

    return useMemo(() => {
        if (!baggageInfo) {
            return {
                included: {
                    count: 0,
                    source: null,
                },
            };
        }

        const flatBaggage = flatten(baggageInfo).filter(Boolean);

        if (!flatBaggage.length) {
            return {
                included: {
                    count: 0,
                    source: null,
                },
            };
        }

        return flatBaggage.reduce((accWorstBaggage, baggage) => {
            if (
                !accWorstBaggage.included?.count ||
                !accWorstBaggage.wt?.count ||
                !accWorstBaggage.pc?.count
            ) {
                return accWorstBaggage;
            }

            if (
                !baggage.included?.count ||
                !baggage.wt?.count ||
                !baggage.pc?.count
            ) {
                return baggage;
            }

            if (baggage.wt.count < accWorstBaggage.wt.count) {
                return baggage;
            } else if (baggage.wt.count === accWorstBaggage.wt.count) {
                return baggage.pc.count < accWorstBaggage.pc.count
                    ? baggage
                    : accWorstBaggage;
            }

            return accWorstBaggage;
        });
    }, [baggageInfo]);
}
